/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.html;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.awt.Color;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CssColorParser {
    private static final Map<String, String> htmlNamedColors = Map.ofEntries(new AbstractMap.SimpleEntry<String, String>("aliceblue", "#F0F8FF"), new AbstractMap.SimpleEntry<String, String>("antiquewhite", "#FAEBD7"), new AbstractMap.SimpleEntry<String, String>("aqua", "#00FFFF"), new AbstractMap.SimpleEntry<String, String>("aquamarine", "#7FFFD4"), new AbstractMap.SimpleEntry<String, String>("azure", "#F0FFFF"), new AbstractMap.SimpleEntry<String, String>("beige", "#F5F5DC"), new AbstractMap.SimpleEntry<String, String>("bisque", "#FFE4C4"), new AbstractMap.SimpleEntry<String, String>("black", "#000000"), new AbstractMap.SimpleEntry<String, String>("blanchedalmond", "#FFEBCD"), new AbstractMap.SimpleEntry<String, String>("blue", "#0000FF"), new AbstractMap.SimpleEntry<String, String>("blueviolet", "#8A2BE2"), new AbstractMap.SimpleEntry<String, String>("brown", "#A52A2A"), new AbstractMap.SimpleEntry<String, String>("burlywood", "#DEB887"), new AbstractMap.SimpleEntry<String, String>("cadetblue", "#5F9EA0"), new AbstractMap.SimpleEntry<String, String>("chartreuse", "#7FFF00"), new AbstractMap.SimpleEntry<String, String>("chocolate", "#D2691E"), new AbstractMap.SimpleEntry<String, String>("coral", "#FF7F50"), new AbstractMap.SimpleEntry<String, String>("cornflowerblue", "#6495ED"), new AbstractMap.SimpleEntry<String, String>("cornsilk", "#FFF8DC"), new AbstractMap.SimpleEntry<String, String>("crimson", "#DC143C"), new AbstractMap.SimpleEntry<String, String>("cyan", "#00FFFF"), new AbstractMap.SimpleEntry<String, String>("darkblue", "#00008B"), new AbstractMap.SimpleEntry<String, String>("darkcyan", "#008B8B"), new AbstractMap.SimpleEntry<String, String>("darkgoldenrod", "#B8860B"), new AbstractMap.SimpleEntry<String, String>("darkgrey", "#A9A9A9"), new AbstractMap.SimpleEntry<String, String>("darkgreen", "#006400"), new AbstractMap.SimpleEntry<String, String>("darkkhaki", "#BDB76B"), new AbstractMap.SimpleEntry<String, String>("darkmagenta", "#8B008B"), new AbstractMap.SimpleEntry<String, String>("darkolivegreen", "#556B2F"), new AbstractMap.SimpleEntry<String, String>("darkorange", "#FF8C00"), new AbstractMap.SimpleEntry<String, String>("darkorchid", "#9932CC"), new AbstractMap.SimpleEntry<String, String>("darkred", "#8B0000"), new AbstractMap.SimpleEntry<String, String>("darksalmon", "#E9967A"), new AbstractMap.SimpleEntry<String, String>("darkseagreen", "#8FBC8F"), new AbstractMap.SimpleEntry<String, String>("darkslateblue", "#483D8B"), new AbstractMap.SimpleEntry<String, String>("darkslategrey", "#2F4F4F"), new AbstractMap.SimpleEntry<String, String>("darkturquoise", "#00CED1"), new AbstractMap.SimpleEntry<String, String>("darkviolet", "#9400D3"), new AbstractMap.SimpleEntry<String, String>("deeppink", "#FF1493"), new AbstractMap.SimpleEntry<String, String>("deepskyblue", "#00BFFF"), new AbstractMap.SimpleEntry<String, String>("dimgray", "#696969"), new AbstractMap.SimpleEntry<String, String>("dodgerblue", "#1E90FF"), new AbstractMap.SimpleEntry<String, String>("firebrick", "#B22222"), new AbstractMap.SimpleEntry<String, String>("floralwhite", "#FFFAF0"), new AbstractMap.SimpleEntry<String, String>("forestgreen", "#228B22"), new AbstractMap.SimpleEntry<String, String>("fuchsia", "#FF00FF"), new AbstractMap.SimpleEntry<String, String>("gainsboro", "#DCDCDC"), new AbstractMap.SimpleEntry<String, String>("ghostwhite", "#F8F8FF"), new AbstractMap.SimpleEntry<String, String>("gold", "#FFD700"), new AbstractMap.SimpleEntry<String, String>("goldenrod", "#DAA520"), new AbstractMap.SimpleEntry<String, String>("grey", "#808080"), new AbstractMap.SimpleEntry<String, String>("green", "#008000"), new AbstractMap.SimpleEntry<String, String>("greenyellow", "#ADFF2F"), new AbstractMap.SimpleEntry<String, String>("honeydew", "#F0FFF0"), new AbstractMap.SimpleEntry<String, String>("hotpink", "#FF69B4"), new AbstractMap.SimpleEntry<String, String>("indianred", "#CD5C5C"), new AbstractMap.SimpleEntry<String, String>("indigo", "#4B0082"), new AbstractMap.SimpleEntry<String, String>("ivory", "#FFFFF0"), new AbstractMap.SimpleEntry<String, String>("khaki", "#F0E68C"), new AbstractMap.SimpleEntry<String, String>("lavender", "#E6E6FA"), new AbstractMap.SimpleEntry<String, String>("lavenderblush", "#FFF0F5"), new AbstractMap.SimpleEntry<String, String>("lawngreen", "#7CFC00"), new AbstractMap.SimpleEntry<String, String>("lemonchiffon", "#FFFACD"), new AbstractMap.SimpleEntry<String, String>("lightblue", "#ADD8E6"), new AbstractMap.SimpleEntry<String, String>("lightcoral", "#F08080"), new AbstractMap.SimpleEntry<String, String>("lightcyan", "#E0FFFF"), new AbstractMap.SimpleEntry<String, String>("lightgoldenrodyellow", "#FAFAD2"), new AbstractMap.SimpleEntry<String, String>("lightgrey", "#D3D3D3"), new AbstractMap.SimpleEntry<String, String>("lightgreen", "#90EE90"), new AbstractMap.SimpleEntry<String, String>("lightpink", "#FFB6C1"), new AbstractMap.SimpleEntry<String, String>("lightsalmon", "#FFA07A"), new AbstractMap.SimpleEntry<String, String>("lightseagreen", "#20B2AA"), new AbstractMap.SimpleEntry<String, String>("lightskyblue", "#87CEFA"), new AbstractMap.SimpleEntry<String, String>("lightslategrey", "#778899"), new AbstractMap.SimpleEntry<String, String>("lightsteelblue", "#B0C4DE"), new AbstractMap.SimpleEntry<String, String>("lightyellow", "#FFFFE0"), new AbstractMap.SimpleEntry<String, String>("lime", "#00FF00"), new AbstractMap.SimpleEntry<String, String>("limegreen", "#32CD32"), new AbstractMap.SimpleEntry<String, String>("linen", "#FAF0E6"), new AbstractMap.SimpleEntry<String, String>("magenta", "#FF00FF"), new AbstractMap.SimpleEntry<String, String>("maroon", "#800000"), new AbstractMap.SimpleEntry<String, String>("mediumaquamarine", "#66CDAA"), new AbstractMap.SimpleEntry<String, String>("mediumblue", "#0000CD"), new AbstractMap.SimpleEntry<String, String>("mediumorchid", "#BA55D3"), new AbstractMap.SimpleEntry<String, String>("mediumpurple", "#9370D8"), new AbstractMap.SimpleEntry<String, String>("mediumseagreen", "#3CB371"), new AbstractMap.SimpleEntry<String, String>("mediumslateblue", "#7B68EE"), new AbstractMap.SimpleEntry<String, String>("mediumspringgreen", "#00FA9A"), new AbstractMap.SimpleEntry<String, String>("mediumturquoise", "#48D1CC"), new AbstractMap.SimpleEntry<String, String>("mediumvioletred", "#C71585"), new AbstractMap.SimpleEntry<String, String>("midnightblue", "#191970"), new AbstractMap.SimpleEntry<String, String>("mintcream", "#F5FFFA"), new AbstractMap.SimpleEntry<String, String>("mistyrose", "#FFE4E1"), new AbstractMap.SimpleEntry<String, String>("moccasin", "#FFE4B5"), new AbstractMap.SimpleEntry<String, String>("navajowhite", "#FFDEAD"), new AbstractMap.SimpleEntry<String, String>("navy", "#000080"), new AbstractMap.SimpleEntry<String, String>("oldlace", "#FDF5E6"), new AbstractMap.SimpleEntry<String, String>("olive", "#808000"), new AbstractMap.SimpleEntry<String, String>("olivedrab", "#6B8E23"), new AbstractMap.SimpleEntry<String, String>("orange", "#FFA500"), new AbstractMap.SimpleEntry<String, String>("orangered", "#FF4500"), new AbstractMap.SimpleEntry<String, String>("orchid", "#DA70D6"), new AbstractMap.SimpleEntry<String, String>("palegoldenrod", "#EEE8AA"), new AbstractMap.SimpleEntry<String, String>("palegreen", "#98FB98"), new AbstractMap.SimpleEntry<String, String>("paleturquoise", "#AFEEEE"), new AbstractMap.SimpleEntry<String, String>("palevioletred", "#D87093"), new AbstractMap.SimpleEntry<String, String>("papayawhip", "#FFEFD5"), new AbstractMap.SimpleEntry<String, String>("peachpuff", "#FFDAB9"), new AbstractMap.SimpleEntry<String, String>("peru", "#CD853F"), new AbstractMap.SimpleEntry<String, String>("pink", "#FFC0CB"), new AbstractMap.SimpleEntry<String, String>("plum", "#DDA0DD"), new AbstractMap.SimpleEntry<String, String>("powderblue", "#B0E0E6"), new AbstractMap.SimpleEntry<String, String>("purple", "#800080"), new AbstractMap.SimpleEntry<String, String>("red", "#FF0000"), new AbstractMap.SimpleEntry<String, String>("rosybrown", "#BC8F8F"), new AbstractMap.SimpleEntry<String, String>("royalblue", "#4169E1"), new AbstractMap.SimpleEntry<String, String>("saddlebrown", "#8B4513"), new AbstractMap.SimpleEntry<String, String>("salmon", "#FA8072"), new AbstractMap.SimpleEntry<String, String>("sandybrown", "#F4A460"), new AbstractMap.SimpleEntry<String, String>("seagreen", "#2E8B57"), new AbstractMap.SimpleEntry<String, String>("seashell", "#FFF5EE"), new AbstractMap.SimpleEntry<String, String>("sienna", "#A0522D"), new AbstractMap.SimpleEntry<String, String>("silver", "#C0C0C0"), new AbstractMap.SimpleEntry<String, String>("skyblue", "#87CEEB"), new AbstractMap.SimpleEntry<String, String>("slateblue", "#6A5ACD"), new AbstractMap.SimpleEntry<String, String>("slategrey", "#708090"), new AbstractMap.SimpleEntry<String, String>("snow", "#FFFAFA"), new AbstractMap.SimpleEntry<String, String>("springgreen", "#00FF7F"), new AbstractMap.SimpleEntry<String, String>("steelblue", "#4682B4"), new AbstractMap.SimpleEntry<String, String>("tan", "#D2B48C"), new AbstractMap.SimpleEntry<String, String>("teal", "#008080"), new AbstractMap.SimpleEntry<String, String>("thistle", "#D8BFD8"), new AbstractMap.SimpleEntry<String, String>("tomato", "#FF6347"), new AbstractMap.SimpleEntry<String, String>("turquoise", "#40E0D0"), new AbstractMap.SimpleEntry<String, String>("violet", "#EE82EE"), new AbstractMap.SimpleEntry<String, String>("wheat", "#F5DEB3"), new AbstractMap.SimpleEntry<String, String>("white", "#FFFFFF"), new AbstractMap.SimpleEntry<String, String>("whitesmoke", "#F5F5F5"), new AbstractMap.SimpleEntry<String, String>("yellow", "#FFFF00"), new AbstractMap.SimpleEntry<String, String>("yellowgreen", "#9ACD32"));

    @Nullable
    public static Color toColor(String cssColor) {
        if (Strings.isNullOrEmpty(cssColor)) {
            return null;
        }
        if (cssColor.startsWith("#")) {
            return Color.decode(cssColor);
        }
        if (cssColor.startsWith("rgba(")) {
            return CssColorParser.rgbaToColor(cssColor);
        }
        if (cssColor.startsWith("rgb(")) {
            return CssColorParser.rgbToColor(cssColor);
        }
        if (cssColor.startsWith("hsla(")) {
            return CssColorParser.hslaToColor(cssColor);
        }
        if (cssColor.startsWith("hsl(")) {
            return CssColorParser.hslToColor(cssColor);
        }
        String namedColor = htmlNamedColors.get(cssColor.trim().toLowerCase());
        if (namedColor != null) {
            return Color.decode(namedColor);
        }
        return null;
    }

    @Nonnull
    public static String toRgbaString(String cs) {
        Color color = CssColorParser.toColor(cs);
        if (color == null) {
            return "";
        }
        return "rgba(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + (color.getAlpha() == 255 ? "1" : String.format("%.2f", Float.valueOf((float)color.getAlpha() / 255.0f))) + ")";
    }

    @Nullable
    private static Color rgbToColor(String rgb) {
        List<String> parts = Splitter.on(',').splitToList(rgb.substring(4, rgb.length() - 1));
        try {
            int r = Integer.parseInt(parts.get(0).trim());
            int g2 = Integer.parseInt(parts.get(1).trim());
            int b = Integer.parseInt(parts.get(2).trim());
            return new Color((float)r / 255.0f, (float)g2 / 255.0f, (float)b / 255.0f);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    private static Color rgbaToColor(String rgba) {
        List<String> parts = Splitter.on(',').splitToList(rgba.substring(5, rgba.length() - 1));
        try {
            int r = Integer.parseInt(parts.get(0).trim());
            int g2 = Integer.parseInt(parts.get(1).trim());
            int b = Integer.parseInt(parts.get(2).trim());
            float a = Float.parseFloat(parts.get(3).trim());
            return new Color((float)r / 255.0f, (float)g2 / 255.0f, (float)b / 255.0f, a);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Color hslToColor(String hsl) {
        List<String> parts = Splitter.on(',').splitToList(hsl.substring(4, hsl.length() - 1));
        String hue = parts.get(0);
        String saturation = parts.get(1);
        String lightness = parts.get(2);
        return CssColorParser.colorFromHsl(hue, saturation, lightness, null);
    }

    public static Color hslaToColor(String hsla) {
        List<String> parts = Splitter.on(',').splitToList(hsla.substring(5, hsla.length() - 1));
        String hue = parts.get(0);
        String saturation = parts.get(1);
        String lightness = parts.get(2);
        String alpha = parts.get(3);
        return CssColorParser.colorFromHsl(hue, saturation, lightness, alpha);
    }

    @Nullable
    private static Color colorFromHsl(String hueString, String saturationString, String lightnessString, @Nullable String alphaString) {
        try {
            float hue = Float.parseFloat(hueString.trim()) / 360.0f;
            float saturation = Float.parseFloat(saturationString.trim().substring(0, saturationString.length() - 1)) / 100.0f;
            float lightness = Float.parseFloat(lightnessString.trim().substring(0, lightnessString.length() - 1)) / 100.0f;
            Float alpha = alphaString == null ? null : Float.valueOf(Float.parseFloat(alphaString.trim()));
            float[] rgb = new float[3];
            if (saturation == 0.0f) {
                rgb[0] = lightness;
                rgb[1] = lightness;
                rgb[2] = lightness;
            } else {
                float q = (double)lightness < 0.5 ? lightness * (1.0f + saturation) : lightness + saturation - lightness * saturation;
                float p = 2.0f * lightness - q;
                rgb[0] = CssColorParser.hueToRgb(p, q, hue + 0.33333334f);
                rgb[1] = CssColorParser.hueToRgb(p, q, hue);
                rgb[2] = CssColorParser.hueToRgb(p, q, hue - 0.33333334f);
            }
            if (alpha != null) {
                return new Color(rgb[0], rgb[1], rgb[2], alpha.floatValue());
            }
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static float hueToRgb(float p, float q, float t) {
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        if (t < 0.16666667f) {
            return p + (q - p) * 6.0f * t;
        }
        if (t < 0.5f) {
            return q;
        }
        if (t < 0.6666667f) {
            return p + (q - p) * (0.6666667f - t) * 6.0f;
        }
        return p;
    }
}

